<div class="content-wrapper">
<section class="content">

<div class="card card-primary">
<div class="card-header">
    <h3>Edit Booking #<?php echo e($booking->id); ?></h3>
</div>

<form method="POST" action="<?php echo e(route('bookings.update', $booking->id)); ?>">
<?php echo csrf_field(); ?>
<?php echo method_field('POST'); ?>

<div class="card-body">

  
  <div class="form-group">
    <label>User</label>
    <input type="text" class="form-control"
           value="<?php echo e($booking->user_name); ?> (<?php echo e($booking->user_email); ?>)"
           readonly>
  </div>

  
  <div class="form-group">
    <label>Property</label>
    <input type="text" class="form-control"
           value="<?php echo e($booking->property_name); ?>"
           readonly>
    <small class="text-muted">
      <?php echo e($booking->locality_name); ?>,
      <?php echo e($booking->city_name); ?>,
      <?php echo e($booking->state_name); ?>,
      <?php echo e($booking->property_address); ?>

    </small>
  </div>

  
  <div class="form-group">
    <label>Check In Time</label>
    <input type="datetime-local"
           name="check_in_time"
           class="form-control"
           value="<?php echo e(date('Y-m-d\TH:i', strtotime($booking->check_in_time))); ?>"
           required>
  </div>

  
  <div class="form-group">
    <label>Check Out Time</label>
    <input type="datetime-local"
           name="check_out_time"
           class="form-control"
           value="<?php echo e(date('Y-m-d\TH:i', strtotime($booking->check_out_time))); ?>"
           required>
  </div>

  
  <div class="form-group">
    <label>Payment Status</label>
    <input type="text" class="form-control"
           value="<?php echo e(ucfirst($booking->payment_status)); ?>"
           readonly>
  </div>

  
  <div class="form-group">
    <label>Booking Status</label>
    <select name="booking_status" class="form-control" required>
      <option value="approved" <?php echo e($booking->booking_status=='approved'?'selected':''); ?>>Approved</option>
      <option value="completed" <?php echo e($booking->booking_status=='completed'?'selected':''); ?>>Completed</option>
      <option value="rejected" <?php echo e($booking->booking_status=='rejected'?'selected':''); ?>>Rejected</option>
    </select>
  </div>

  
  <div class="form-group">
    <label>Admin Note</label>
    <textarea name="admin_note"
              class="form-control"
              rows="4"
              placeholder="Enter admin note"
              required><?php echo e($booking->admin_note ?? ''); ?></textarea>
  </div>

</div>

<div class="card-footer">
  <button class="btn btn-primary">Update Booking</button>
  <a href="<?php echo e(route('bookings.index')); ?>" class="btn btn-secondary">Back</a>
</div>

</form>
</div>

</section>
</div>
<?php /**PATH /var/www/html/pc/hide/resources/views/users/booking_edit.blade.php ENDPATH**/ ?>