
<div class="content-wrapper">
<section class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-md-12"><!-- full width -->
        <div class="card card-primary">
          <div class="card-header">
            <h3 class="card-title">Ticket #<?php echo e($ticket->id); ?> - <?php echo e($ticket->subject); ?></h3>
          </div>

          <div class="card-body">
            <?php if(session('success')): ?> <div class="alert alert-success"><?php echo e(session('success')); ?></div> <?php endif; ?>

            <div class="mb-3">
              <strong>User ID:</strong> <?php echo e($ticket->user_id ?? '-'); ?><br>
              <strong>Email:</strong> <?php echo e($ticket->email); ?><br>
              <strong>Created:</strong> <?php echo e(\Carbon\Carbon::parse($ticket->created_at)->format('Y-m-d H:i')); ?><br>
              <strong>Status:</strong>
              <?php if($ticket->status == 'active'): ?> <span class="badge badge-success">Active</span>
              <?php else: ?> <span class="badge badge-secondary">Closed</span> <?php endif; ?>
            </div>

            <div class="card card-outline card-default">
              <div class="card-header"><h5 class="card-title">Issue</h5></div>
              <div class="card-body">
                <pre style="white-space:pre-wrap"><?php echo e($ticket->issue); ?></pre>
              </div>
            </div>

            <hr>

            <form method="POST" action="<?php echo e(route('admin.tickets.update', $ticket->id)); ?>">
              <?php echo csrf_field(); ?>
              <div class="form-group">
                <label for="status">Status</label>
                <select name="status" class="form-control" id="status">
                  <option value="active" <?php echo e($ticket->status=='active'?'selected':''); ?>>Active</option>
                  <option value="closed" <?php echo e($ticket->status=='closed'?'selected':''); ?>>Closed</option>
                </select>
                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
              </div>

              <div class="form-group">
                <label for="admin_reply">Admin Note (optional)</label>
                <textarea name="admin_reply" id="admin_reply" class="form-control" rows="4" placeholder="Write internal note or reply (not saved in DB in this version)"></textarea>
              </div>

              <div class="card-footer">
                <a href="<?php echo e(route('admin.tickets.index')); ?>" class="btn btn-secondary">Back</a>
                <button type="submit" class="btn btn-primary">Update Ticket</button>
              </div>
            </form>

          </div>
        </div>
      </div>
    </div>
  </div>
</section>
</div>
<?php /**PATH /var/www/html/pc/hide/resources/views/extra_services/ticket_view.blade.php ENDPATH**/ ?>