
<?php
    use Illuminate\Support\Str;
    // base path for images (S3 or local) — same logic as listing
    $propertiesBase = config('app.properties_image_path') ?: env('PROPERTIES_IMAGE_PATH', null);
    $propertiesBase = $propertiesBase ? rtrim($propertiesBase, '/') : null;

    // visible slug used in links/forms: slugified name + '-' + id
    $visibleSlug = Str::slug($property->name ?? 'property-' . $property->id) . '-' . $property->id;

    // prepare features array (trim, remove empty)
    $featuresArr = [];
    if (!empty($property->features)) {
        $featuresArr = array_filter(array_map('trim', explode(',', $property->features)));
    }
?>

<div class="content-wrapper">
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h3 class="card-title">View Property: <?php echo e($property->name); ?></h3>
            <div class="btn-group" role="group" aria-label="actions">
                <a href="<?php echo e(url()->previous()); ?>" class="btn btn-light btn-sm">Back</a>

                <?php if($property->status === 'pending'): ?>
                    <form action="<?php echo e(route('admin.properties.approve', $visibleSlug)); ?>" method="POST" style="display:inline-block;">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="btn btn-sm btn-primary" onclick="return confirm('Approve this property?')">Approve</button>
                    </form>
                    <form action="<?php echo e(route('admin.properties.reject', $visibleSlug)); ?>" method="POST" style="display:inline-block;">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Reject this property?')">Reject</button>
                    </form>
                <?php else: ?>
                    <a href="<?php echo e(route('properties.edit', $visibleSlug)); ?>" class="btn btn-primary btn-sm">Edit</a>

                    <form action="<?php echo e(route('properties.destroy', $visibleSlug)); ?>" method="POST" style="display:inline-block;">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to deactivate this property?')">
                            Deactivate
                        </button>
                    </form>
                <?php endif; ?>
            </div>
        </div>

        <div class="card-body">
            <div class="row">
                
                <div class="col-md-6">
                    <?php if(isset($images) && $images->count()): ?>
                        <div id="propertyCarousel" class="carousel slide" data-ride="carousel">
                            <div class="carousel-inner">
                                <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        if ($propertiesBase) {
                                            $imgUrl = $propertiesBase . '/' . ltrim($img->filename, '/');
                                        } else {
                                            $imgUrl = asset('storage/uploads/properties/' . $property->id . '/' . ltrim($img->filename, '/'));
                                        }
                                    ?>

                                    <div class="carousel-item <?php echo e($idx === 0 ? 'active' : ''); ?>">
                                        <img src="<?php echo e($imgUrl); ?>" class="d-block w-100" style="height:380px; object-fit:cover;" alt="property-image-<?php echo e($idx); ?>">
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                            <?php if($images->count() > 1): ?>
                                <a class="carousel-control-prev" href="#propertyCarousel" role="button" data-slide="prev">
                                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                    <span class="sr-only">Previous</span>
                                </a>
                                <a class="carousel-control-next" href="#propertyCarousel" role="button" data-slide="next">
                                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                    <span class="sr-only">Next</span>
                                </a>
                            <?php endif; ?>
                        </div>

                        
                        <div class="mt-2 d-flex flex-wrap">
                            <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $thumbIndex => $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    if ($propertiesBase) {
                                        $thumb = $propertiesBase . '/' . ltrim($img->filename, '/');
                                    } else {
                                        $thumb = asset('storage/uploads/properties/' . $property->id . '/' . ltrim($img->filename, '/'));
                                    }
                                ?>
                                <img src="<?php echo e($thumb); ?>"
                                     class="property-thumb"
                                     data-index="<?php echo e($thumbIndex); ?>"
                                     style="width:90px;height:66px;object-fit:cover;border:1px solid #ddd;margin-right:8px;margin-bottom:8px;cursor:pointer;" />
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php else: ?>
                        <div class="text-center text-muted" style="height:380px;display:flex;align-items:center;justify-content:center;border:1px dashed #ddd;">No images available</div>
                    <?php endif; ?>
                </div>

                
                <div class="col-md-6">
                    <table class="table table-borderless">
                        <tr>
                            <th style="width:140px">Place Name</th>
                            <td><?php echo e($property->name); ?></td>
                        </tr>

                        <tr>
                            <th>Location</th>
                            <td>
                                <?php echo e($property->state_name ?? ''); ?> / <?php echo e($property->city_name ?? ''); ?>

                                <?php if(!empty($property->locality_id)): ?><div><small><?php echo e($property->locality_id); ?></small></div><?php endif; ?>
                                <?php if(!empty($property->address)): ?><div><small><?php echo e($property->address); ?></small></div><?php endif; ?>
                            </td>
                        </tr>

                        <tr>
                            <th>Price</th>
                            <td>₹<?php echo e(number_format($property->price ?? 0, 2)); ?>

                                <div><small><?php echo e(ucfirst(str_replace('_',' ',$property->price_unit ?? ''))); ?></small></div>
                            </td>
                        </tr>

                        
                        <tr>
                            <th>Features</th>
                            <td>
                                <?php if(count($featuresArr)): ?>
                                    <?php echo e(implode(', ', $featuresArr)); ?>

                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                        </tr>

                        <tr>
                            <th>Status</th>
                            <td>
                                <?php if($property->status === 'active'): ?>
                                    <span class="badge badge-success">Active</span>
                                <?php elseif($property->status === 'pending'): ?>
                                    <span class="badge badge-warning">Pending</span>
                                <?php elseif($property->status === 'reject' || $property->status === 'rejected'): ?>
                                    <span class="badge badge-danger">Rejected</span>
                                <?php else: ?>
                                    <span class="badge badge-secondary"><?php echo e(ucfirst($property->status)); ?></span>
                                <?php endif; ?>
                            </td>
                        </tr>

                        <tr>
                            <th>Created At</th>
                            <td><?php echo e($property->created_at); ?></td>
                        </tr>
                    </table>

                    <?php if(!empty($property->contact_name) || !empty($property->contact_phone) || !empty($property->contact_email)): ?>
                        <div class="mt-3">
                            <h5>Contact</h5>
                            <p class="mb-0"><strong>Name:</strong> <?php echo e($property->contact_name ?? '-'); ?></p>
                            <p class="mb-0"><strong>Phone:</strong> <?php echo e($property->contact_phone ?? '-'); ?></p>
                            <p class="mb-0"><strong>Email:</strong> <?php echo e($property->contact_email ?? '-'); ?></p>
                        </div>
                    <?php endif; ?>

                    
                    <?php if(!empty($property->map_iframe)): ?>
                        <div class="mt-3">
                            <?php echo $property->map_iframe; ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>

            
            <?php if(!empty($property->description)): ?>
                <div class="mt-4">
                    <h5>Description</h5>
                    <p><?php echo nl2br(e($property->description)); ?></p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>


<script>
    $(function () {
        $('#propertyCarousel').carousel({ interval: 5000 });

        // thumbnail -> slide
        $('.property-thumb').on('click', function () {
            var idx = parseInt($(this).data('index'), 10);
            $('#propertyCarousel').carousel(idx);
        });
    });
</script>
<?php /**PATH /var/www/html/pc/hide/resources/views/properties/property_view.blade.php ENDPATH**/ ?>