

<div class="content-wrapper">

<div class="card">
 <div class="card-header">
    <h3 class="card-title">States List</h3>
    <a href="<?php echo e(route('states.create')); ?>" class="btn btn-success float-right">Add State</a>
</div>

    <div class="card-body">
        <!-- <?php if(session('success')): ?>
          <div class="alert alert-success"><?php echo e(session('success')); ?></div>
        <?php endif; ?> -->

        <table id="example1" class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Status</th>
                    <th>Created At</th>
                    <th>Action</th>
                </tr>
            </thead>
           <tbody>
    <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <tr>
        <td><?php echo e($loop->iteration); ?></td> <!-- Serial number -->
        <td><?php echo e($state->name); ?></td>
        <td><?php echo e($state->status); ?></td>
        <td><?php echo e($state->created_at); ?></td>
        <td>
            <a href="<?php echo e(route('states.edit', $state->id)); ?>" class="btn btn-primary btn-sm">Edit</a>

            <form action="<?php echo e(route('states.destroy', $state->id)); ?>" method="POST" style="display:inline;">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="btn btn-danger btn-sm"
                    onclick="return confirm('Are you sure you want to deactivate this state?')">Deactivate</button>
            </form>
        </td>
    </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</tbody>
        </table>
    </div>
</div>

<script>
$(function () {
    $("#example1").DataTable({
        "responsive": true,
        "lengthChange": false,
        "autoWidth": false,
        "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
});
</script>
</div>
<?php /**PATH /var/www/html/pc/hide/resources/views/states/statelisting.blade.php ENDPATH**/ ?>