<div class="content-wrapper">
<section class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-md-12">
        <div class="card card-primary">
          <div class="card-header">
            <h3 class="card-title"><?php echo e(isset($city) ? 'Edit City' : 'Add City'); ?></h3>
          </div>
          <form id="quickForm" method="POST" 
                action="<?php echo e(isset($city) ? route('cities.update', $city->id) : route('cities.store')); ?>">
            <?php echo csrf_field(); ?>
            <?php if(isset($city)): ?>
                <?php echo method_field('PUT'); ?>
            <?php endif; ?>
            <div class="card-body">
                   <div class="form-group">
                <label for="state_id">State</label>
                <select name="state_id" id="state_id" class="form-control">
                  <option value="">-- Select State --</option>
                  <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($state->id); ?>" 
                      <?php echo e((isset($city) && $city->state_id == $state->id) ? 'selected' : ''); ?>>
                      <?php echo e($state->name); ?>

                    </option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>
              <div class="form-group">
                <label for="name">City Name</label>
                <input type="text" name="name" value="<?php echo e($city->name ?? ''); ?>" 
                       class="form-control" id="name" placeholder="Enter City Name">
              </div>
           
              <div class="form-group">
                <label for="status">Status</label>
                <select name="status" class="form-control" id="status">
                  <option value="active" <?php echo e((isset($city) && $city->status=='active')?'selected':''); ?>>Active</option>
                  <option value="inactive" <?php echo e((isset($city) && $city->status=='inactive')?'selected':''); ?>>Inactive</option>
                </select>
              </div>
            </div>
            <div class="card-footer">
              <button type="submit" class="btn btn-primary"><?php echo e(isset($city) ? 'Update' : 'Submit'); ?></button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</section>
</div>

<script>
$(function () {
  $('#quickForm').validate({
    rules: {
      name: { required: true },
      state_id: { required: true },
      status: { required: true }
    },
    messages: {
      name: "Please enter city name",
      state_id: "Please select a state",
      status: "Please select status"
    },
    errorElement: 'span',
    errorPlacement: function (error, element) {
      error.addClass('invalid-feedback');
      element.closest('.form-group').append(error);
    },
    highlight: function (element) {
      $(element).addClass('is-invalid');
    },
    unhighlight: function (element) {
      $(element).removeClass('is-invalid');
    }
  });
});
</script>
<?php /**PATH /var/www/html/pc/hide/resources/views/cities/citiesform.blade.php ENDPATH**/ ?>