<div class="main-content">
  <div class="page-content">
    <div class="container-fluid">

      <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
      <?php endif; ?>
      <?php if(session('error')): ?>
        <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
      <?php endif; ?>

      <div class="row">
        <div class="col-md-5">
          <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
              <h5 class="mb-0">Your Bank Accounts</h5>
              <button id="btnAddNew" class="btn btn-sm btn-primary">+ Add More</button>
            </div>
            <div class="card-body">
              <?php if($accounts && $accounts->count()): ?>
                <div class="list-group">
                  <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $acc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="list-group-item d-flex justify-content-between align-items-center">
                      <div>
                        <div><strong><?php echo e($acc->bank_name); ?></strong> — <?php echo e($acc->branch_name); ?></div>
                        <div class="small text-muted"><?php echo e($acc->name_in_bank); ?> • A/c: ****<?php echo e(substr($acc->account_number, -4)); ?> • IFSC: <?php echo e($acc->ifsc); ?></div>
                        <div class="mt-1">
                          <span class="badge bg-<?php echo e($acc->status === 'active' ? 'success' : 'secondary'); ?>"><?php echo e(ucfirst($acc->status)); ?></span>
                        </div>
                      </div>

                      <div class="text-end">
                        <button class="btn btn-sm btn-outline-primary btn-edit-account"
                                data-account='<?php echo json_encode($acc, 15, 512) ?>'>
                          Edit
                        </button>
                      </div>
                    </div>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
              <?php else: ?>
                <div class="alert alert-info mb-0">No bank accounts found. Add one using the form.</div>
              <?php endif; ?>
            </div>
          </div>
        </div>

        <div class="col-md-7">
          <div class="card">
            <div class="card-header">
              <h5 class="mb-0" id="formTitle">Add Bank Account</h5>
            </div>

            <div class="card-body">
              
              <form id="bankForm" class="row g-3 needs-validation" method="POST" action="<?php echo e(route('merchant.bank.store')); ?>" novalidate>
                <?php echo csrf_field(); ?>

                <input type="hidden" name="account_id" id="account_id" value="">

                <div class="col-md-6">
                  <label class="form-label">Name (as in bank)</label>
                  <input type="text" name="name_in_bank" id="name_in_bank" class="form-control" value="<?php echo e(old('name_in_bank')); ?>" required>
                </div>

                <div class="col-md-6">
                  <label class="form-label">Bank Name</label>
                  <input type="text" name="bank_name" id="bank_name" class="form-control" value="<?php echo e(old('bank_name')); ?>" required>
                </div>

                <div class="col-md-6">
                  <label class="form-label">Branch Name</label>
                  <input type="text" name="branch_name" id="branch_name" class="form-control" value="<?php echo e(old('branch_name')); ?>">
                </div>

                <div class="col-md-6">
                  <label class="form-label">IFSC</label>
                  <input type="text" name="ifsc" id="ifsc" class="form-control" value="<?php echo e(old('ifsc')); ?>" required>
                </div>

                <div class="col-md-6">
                  <label class="form-label">Account Number</label>
                  <input type="text" name="account_number" id="account_number" class="form-control" value="<?php echo e(old('account_number')); ?>" required>
                </div>

                <div class="col-md-6">
                  <label class="form-label">Confirm Account Number</label>
                  <input type="text" name="confirm_account_number" id="confirm_account_number" class="form-control" value="<?php echo e(old('confirm_account_number')); ?>" required>
                </div>

                <div class="col-md-4">
                  <label class="form-label">Status</label>
                  <select name="status" id="status" class="form-select">
                    <option value="active">Active</option>
                    <option value="inactive">Inactive</option>
                  </select>
                </div>

                <div class="col-12">
                  <button id="submitBtn" class="btn btn-primary">Save Account</button>
                  <a href="<?php echo e(route('merchant.index')); ?>" class="btn btn-secondary">Back</a>
                </div>
              </form>

              
              <?php if($errors->any()): ?>
                <div class="mt-3">
                  <div class="alert alert-danger">
                    <ul class="mb-0">
                      <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $err): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($err); ?></li>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                  </div>
                </div>
              <?php endif; ?>

            </div>
          </div>
        </div>
      </div><!-- row -->

    </div>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
  const addBtn = document.getElementById('btnAddNew');
  const editButtons = document.querySelectorAll('.btn-edit-account');

  const form = document.getElementById('bankForm');
  const formTitle = document.getElementById('formTitle');
  const accountIdInput = document.getElementById('account_id');

  const fields = {
    name_in_bank: document.getElementById('name_in_bank'),
    bank_name: document.getElementById('bank_name'),
    branch_name: document.getElementById('branch_name'),
    ifsc: document.getElementById('ifsc'),
    account_number: document.getElementById('account_number'),
    confirm_account_number: document.getElementById('confirm_account_number'),
    status: document.getElementById('status')
  };

  // helper to clear form for "Add More"
  function clearForm() {
    accountIdInput.value = '';
    form.action = "<?php echo e(route('merchant.bank.store')); ?>";
    formTitle.textContent = 'Add Bank Account';
    Object.values(fields).forEach(f => {
      if (f.tagName === 'SELECT' || f.tagName === 'INPUT' || f.tagName === 'TEXTAREA') {
        f.value = '';
      }
    });
    // default status active
    fields.status.value = 'active';
  }

  // Add new account
  addBtn.addEventListener('click', function (e) {
    e.preventDefault();
    clearForm();
    window.scrollTo({ top: form.getBoundingClientRect().top + window.pageYOffset - 100, behavior: 'smooth' });
  });

  // Edit existing account: populate form
  editButtons.forEach(btn => {
    btn.addEventListener('click', function (e) {
      e.preventDefault();
      const acc = JSON.parse(this.dataset.account);
      accountIdInput.value = acc.id;
      fields.name_in_bank.value = acc.name_in_bank || '';
      fields.bank_name.value = acc.bank_name || '';
      fields.branch_name.value = acc.branch_name || '';
      fields.ifsc.value = acc.ifsc || '';
      fields.account_number.value = acc.account_number || '';
      fields.confirm_account_number.value = acc.account_number || '';
      fields.status.value = acc.status || 'active';

      form.action = "<?php echo e(route('merchant.bank.update')); ?>";
      formTitle.textContent = 'Edit Bank Account';
      window.scrollTo({ top: form.getBoundingClientRect().top + window.pageYOffset - 100, behavior: 'smooth' });
    });
  });

  // client-side account confirm check
  form.addEventListener('submit', function (e) {
    const acc = fields.account_number.value.trim();
    const conf = fields.confirm_account_number.value.trim();
    if (acc === '' || conf === '') {
      // let server show required errors
      return;
    }
    if (acc !== conf) {
      e.preventDefault();
      alert('Account number and Confirm account number do not match.');
      fields.confirm_account_number.focus();
    }
  });

  // initialize default
  clearForm();
});
</script>
<?php /**PATH /var/www/html/pc/hide/resources/views/merchant_panel/bank_details.blade.php ENDPATH**/ ?>