
<div class="content-wrapper">
<section class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-md-12"><!-- full width -->
        <div class="card card-primary">
          <div class="card-header">
            <h3 class="card-title">Support Tickets</h3>
          </div>

          <div class="card-body">
            <?php if(session('success')): ?> <div class="alert alert-success"><?php echo e(session('success')); ?></div> <?php endif; ?>
            <?php if(session('error')): ?>   <div class="alert alert-danger"><?php echo e(session('error')); ?></div>  <?php endif; ?>

            <table class="table table-bordered table-striped">
              <thead>
                <tr>
                  <th>#</th> 
                  <th>Email</th>
                  <th>Subject</th>
                  <th>Status</th>
                  <th>Created</th>
                  <th>Action</th>
                </tr>
              </thead>
              <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                  <td><?php echo e($loop->iteration); ?></td> 
                  <td><?php echo e($t->email); ?></td>
                  <td><?php echo e(\Illuminate\Support\Str::limit($t->subject, 60)); ?></td>
                  <td>
                    <?php if($t->status == 'active'): ?> <span class="badge badge-success">Active</span>
                    <?php else: ?> <span class="badge badge-secondary">Closed</span> <?php endif; ?>
                  </td>
                  <td><?php echo e($t->created_at ? \Carbon\Carbon::parse($t->created_at)->format('Y-m-d H:i') : '-'); ?></td>
                  <td>
                    <a href="<?php echo e(route('admin.tickets.show', $t->id)); ?>" class="btn btn-sm btn-primary w-100">View</a>
                  </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr><td colspan="6" class="text-center">No tickets found</td></tr>
                <?php endif; ?>
              </tbody>
            </table>

          </div>
        </div>
      </div>
    </div>
  </div>
</section>
</div>
<?php /**PATH /var/www/html/pc/hide/resources/views/extra_services/tickets_listing.blade.php ENDPATH**/ ?>