<div class="content-wrapper">

<div class="card">
 <div class="card-header">
    <h3 class="card-title">Extra Services</h3>
    <a href="<?php echo e(route('extra-services.create')); ?>" class="btn btn-success float-right">Add Service</a>
</div>

    <div class="card-body">
        <!-- <?php if(session('success')): ?>
          <div class="alert alert-success"><?php echo e(session('success')); ?></div>
        <?php endif; ?> -->

        <table id="example1" class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Name</th>
                    <th>Price</th>
                    <th>Status</th>
                    <th>Created At</th>
                    <th>Action</th>
                </tr>
            </thead>
           <tbody>
    <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <tr>
        <td><?php echo e($loop->iteration); ?></td> <!-- Serial number -->
        <td><?php echo e($service->name); ?></td>
        <td>
          <div><?php echo e(isset($service->formatted_price) ? $service->formatted_price : '₹'.number_format($service->price,2)); ?></div>
          <small class="text-muted"><?php echo e(isset($service->price_type_label) ? $service->price_type_label : ( $service->price_type == 'per_day' ? 'Per Day' : 'One Time')); ?></small>
        </td>
        <td>
          <?php if($service->status === 'active'): ?>
            <span class="badge badge-success">Active</span>
          <?php else: ?>
            <span class="badge badge-secondary">Inactive</span>
          <?php endif; ?>
        </td>
        <td><?php echo e($service->created_at); ?></td>
        <td>
            <a href="<?php echo e(route('extra-services.edit', $service->id)); ?>" class="btn btn-primary btn-sm">Edit</a>

            <form action="<?php echo e(route('extra-services.destroy', $service->id)); ?>" method="POST" style="display:inline;">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="btn btn-danger btn-sm"
                    onclick="return confirm('Are you sure you want to deactivate this service?')">Deactivate</button>
            </form>
        </td>
    </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</tbody>
        </table>
    </div>
</div>

<script>
$(function () {
    $("#example1").DataTable({
        "responsive": true,
        "lengthChange": false,
        "autoWidth": false,
        "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
});
</script>
</div>
<?php /**PATH /var/www/html/pc/hide/resources/views/extra_services/listing.blade.php ENDPATH**/ ?>