<div class="content-wrapper">
  <div class="card">
    <div class="card-header">
      <h3 class="card-title"><?php echo e(isset($locality) ? 'Edit Locality' : 'Add Locality'); ?></h3>
    </div>
    <div class="card-body">
      <form method="POST" action="<?php echo e(isset($locality) ? route('localities.update', $locality->id) : route('localities.store')); ?>">
        <?php echo csrf_field(); ?>
        <?php if(isset($locality)): ?> <?php echo method_field('PUT'); ?> <?php endif; ?>

        <div class="form-group">
          <label for="city_id">Select City</label>
          <select name="city_id" class="form-control" required>
            <option value="">-- Select City --</option>
            <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($city->id); ?>" <?php echo e(isset($locality) && $locality->city_id == $city->id ? 'selected' : ''); ?>>
                <?php echo e($city->name); ?> (<?php echo e($city->state_name); ?>)
              </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </select>
        </div>

        <div class="form-group">
          <label for="name">Locality Name</label>
          <input type="text" name="name" class="form-control" value="<?php echo e($locality->name ?? ''); ?>" required>
        </div>

        <div class="form-group">
          <label for="status">Status</label>
          <select name="status" class="form-control" required>
            <option value="active" <?php echo e(isset($locality) && $locality->status == 'active' ? 'selected' : ''); ?>>Active</option>
            <option value="inactive" <?php echo e(isset($locality) && $locality->status == 'inactive' ? 'selected' : ''); ?>>Inactive</option>
          </select>
        </div>

        <button type="submit" class="btn btn-success"><?php echo e(isset($locality) ? 'Update' : 'Create'); ?></button>
      </form>
    </div>
  </div>
</div>
<?php /**PATH /var/www/html/pc/hide/resources/views/localities/localityform.blade.php ENDPATH**/ ?>