<div class="content-wrapper">

<section class="content">
  <div class="container-fluid">
    <div class="row">
      <div class="col-md-12">
        <div class="card card-primary">
          <div class="card-header">
            <h3 class="card-title"><?php echo e(isset($state) ? 'Edit State' : 'Add State'); ?></h3>
          </div>
          <form id="quickForm" method="POST" action="<?php echo e(isset($state) ? route('states.update', $state->id) : route('states.store')); ?>">
            <?php echo csrf_field(); ?>
            <?php if(isset($state)): ?>
                <?php echo method_field('PUT'); ?>
            <?php endif; ?>
            <div class="card-body">
              <div class="form-group">
                <label for="name">State Name</label>
                <input type="text" name="name" value="<?php echo e(old('name', $state->name ?? '')); ?>" class="form-control" id="name" placeholder="Enter State Name">
                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
              </div>

              <div class="form-group">
                <label for="status">Status</label>
                <select name="status" class="form-control" id="status">
                  <option value="active" <?php echo e((old('status', $state->status ?? '')=='active')?'selected':''); ?>>Active</option>
                  <option value="inactive" <?php echo e((old('status', $state->status ?? '')=='inactive')?'selected':''); ?>>Inactive</option>
                </select>
                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
              </div>
            </div>
            <div class="card-footer">
              <a href="<?php echo e(route('states.index')); ?>" class="btn btn-secondary">Back</a>
              <button type="submit" class="btn btn-primary"><?php echo e(isset($state) ? 'Update' : 'Submit'); ?></button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</section>

  </div>

<script>
$(function () {
  $('#quickForm').validate({
    rules: {
      name: { required: true },
      status: { required: true }
    },
    messages: {
      name: "Please enter state name",
      status: "Please select status"
    },
    errorElement: 'span',
    errorPlacement: function (error, element) {
      error.addClass('invalid-feedback');
      element.closest('.form-group').append(error);
    },
    highlight: function (element) {
      $(element).addClass('is-invalid');
    },
    unhighlight: function (element) {
      $(element).removeClass('is-invalid');
    }
  });
});
</script>
<?php /**PATH /var/www/html/pc/hide/resources/views/states/stateform.blade.php ENDPATH**/ ?>