<div class="content-wrapper">
  <div class="card">

    <div class="card-header">
      <h3 class="card-title">Bookings</h3>

      <div class="float-right">
        <a href="<?php echo e(route('bookings.index')); ?>" class="btn btn-sm btn-primary">All</a>

        <a href="<?php echo e(route('bookings.index', ['filterKey'=>'payment_status','filterValue'=>'pending'])); ?>"
           class="btn btn-sm btn-warning">Payment Pending</a>

        <a href="<?php echo e(route('bookings.index', ['filterKey'=>'booking_status','filterValue'=>'approved'])); ?>"
           class="btn btn-sm btn-success">Approved</a>

        <a href="<?php echo e(route('bookings.index', ['filterKey'=>'booking_status','filterValue'=>'completed'])); ?>"
           class="btn btn-sm btn-info">Completed</a>

        <a href="<?php echo e(route('bookings.index', ['filterKey'=>'booking_status','filterValue'=>'rejected'])); ?>"
           class="btn btn-sm btn-danger">Rejected</a>
      </div>
    </div>

    
    <div class="p-2">
      <?php if(!empty($filterKey) && !empty($filterValue)): ?>
        <?php
          // helper: try to make user-friendly date text if possible
          $friendly = null;
          if ($filterKey === 'date' && strtotime($filterValue)) {
              $friendly = date('M d, Y', strtotime($filterValue));
          } elseif ($filterKey === 'date_range') {
              $parts = explode('|', $filterValue);
              $from = $parts[0] ?? null;
              $to   = $parts[1] ?? null;
              if ($from && strtotime($from)) $fromF = date('M d, Y', strtotime($from)); else $fromF = $from;
              if ($to   && strtotime($to))   $toF   = date('M d, Y', strtotime($to));   else $toF   = $to;
          }
        ?>

        <div class="alert alert-info p-2" style="margin-bottom:8px;">
          <?php if($filterKey === 'date'): ?>
            Showing bookings for
            <strong><?php echo e(e($filterValue)); ?></strong>
            <?php if(!empty($friendly)): ?> <small class="text-muted">(<?php echo e($friendly); ?>)</small> <?php endif; ?>
          <?php elseif($filterKey === 'date_range'): ?>
            <?php
              // ensure safe display even if explode failed
              $fromDisplay = $parts[0] ?? $filterValue;
              $toDisplay   = $parts[1] ?? null;
            ?>
            Showing bookings from
            <strong><?php echo e(e($fromDisplay)); ?></strong>
            <?php if(!empty($fromF)): ?> <small class="text-muted">(<?php echo e($fromF); ?>)</small> <?php endif; ?>
            <?php if($toDisplay): ?>
              to <strong><?php echo e(e($toDisplay)); ?></strong>
              <?php if(!empty($toF)): ?> <small class="text-muted">(<?php echo e($toF); ?>)</small> <?php endif; ?>
            <?php endif; ?>
          <?php else: ?>
            Filter: <strong><?php echo e(ucfirst(e($filterKey))); ?></strong> = <strong><?php echo e(e($filterValue)); ?></strong>.
          <?php endif; ?>

          <a href="<?php echo e(route('bookings.index')); ?>" class="btn btn-sm btn-outline-dark float-right">Clear filter</a>
        </div>
      <?php endif; ?>
    </div>

    <div class="card-body">
      <table id="bookings_table" class="table table-bordered table-striped">
        <thead>
          <tr>
            <th >ID</th>
            <th >User</th>
            <th class="w-100">Property</th>
            <th class="w-100">Check In</th>
            <th class="w-100">Check Out</th>
            <th class="w-100">Payment</th>
            <th class="w-100">Booking Status</th>
            <th class="w-100">Admin Note</th>
            <th class="w-100">Admin Action Time</th>
            <th class="w-100">Action</th>
          </tr>
        </thead>

        <tbody>
          <?php $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
  <td><?php echo e($loop->iteration); ?></td>

              
              <td>
                <?php echo e($b->user_name ?? 'User #'.$b->user_id); ?><br>
                <small class="text-muted"><?php echo e($b->user_email ?? ''); ?></small>
              </td>

              
              <td>
                <strong><?php echo e($b->property_name ?? 'Property #'.$b->property_id); ?></strong><br>
                <small class="text-muted">
                  <?php echo e($b->locality_name ?? ''); ?>

                  <?php echo e($b->city_name ? ', '.$b->city_name : ''); ?>

                  <?php echo e($b->state_name ? ', '.$b->state_name : ''); ?>

                  <?php echo e($b->property_address ? ', '.$b->property_address : ''); ?>

                </small>
              </td>

              <td><?php echo e($b->check_in_time); ?></td>
              <td><?php echo e($b->check_out_time); ?></td>

              <td><?php echo e(ucfirst($b->payment_status)); ?></td>
              <td><?php echo e(ucfirst($b->booking_status)); ?></td>

              <td><?php echo e($b->admin_note ?? '-'); ?></td>
              <td><?php echo e($b->admin_action_time ?? '-'); ?></td>

              
              <td>
                
                <?php if($b->payment_status === 'pending'): ?>
                  <form action="<?php echo e(route('bookings.approve_payment', $b->id)); ?>"
                        method="POST"
                        style="display:inline"
                        onsubmit="return attachAdminNote(this)">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="admin_note" value="">
                    <button class="btn btn-success btn-sm w-100 ">Approve</button>
                  </form>

                  <form action="<?php echo e(route('bookings.reject_payment', $b->id)); ?>"
                        method="POST"
                        style="display:inline"
                        onsubmit="return attachAdminNote(this)">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="admin_note" value="">
                    <button class="btn btn-danger btn-sm mt-1 w-100">Reject</button>
                  </form>

                  <br>
                <?php endif; ?>

                <?php if($b->booking_status !== 'completed'): ?>
                  <a href="<?php echo e(route('bookings.edit', $b->id)); ?>"
                     class="btn btn-primary btn-sm mt-1 w-100">
                    Update
                  </a>
                <?php endif; ?>
              </td>
            </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<script>
function attachAdminNote(form) {
    let note = prompt("Enter admin note (required):");
    if (!note || note.trim() === '') {
        alert('Admin note is required.');
        return false;
    }
    form.querySelector('input[name="admin_note"]').value = note;
    return true;
}

$(function () {
    $("#bookings_table").DataTable({
        responsive: true,
        lengthChange: false,
        autoWidth: false,
        buttons: ["copy", "csv", "excel", "pdf", "print"]
    }).buttons().container()
      .appendTo('#bookings_table_wrapper .col-md-6:eq(0)');
});
</script>
<?php /**PATH /var/www/html/pc/hide/resources/views/users/bookings_list.blade.php ENDPATH**/ ?>