<div class="main-content">
  <div class="page-content">
    <div class="container-fluid">

      <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
      <?php endif; ?>
      <?php if(session('error')): ?>
        <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
      <?php endif; ?>

      <div class="card">
        <div class="card-header">
          <h4 class="card-title mb-0">Withdrawal Request</h4>
        </div>

        <div class="card-body">
          <p>Your current wallet balance: <strong>₹<?php echo e(number_format($balance,2)); ?></strong></p>

          
          <?php if($canWithdraw): ?>
            <div class="alert alert-success">
              Your balance meets the minimum withdrawal threshold of <strong>₹<?php echo e(number_format($minWithdrawalBalance,2)); ?></strong>. You can request a withdrawal.
            </div>
          <?php else: ?>
            <div class="alert alert-warning">
              Minimum balance of <strong>₹<?php echo e(number_format($minWithdrawalBalance,2)); ?></strong> is required to request a withdrawal.
              You need <strong>₹<?php echo e(number_format(max(0, $minWithdrawalBalance - $balance), 2)); ?></strong> more to become eligible.
            </div>
          <?php endif; ?>

          <form id="withdrawalForm" method="POST" action="<?php echo e(route('merchant.withdraw.store')); ?>" class="row g-3 needs-validation" novalidate>
            <?php echo csrf_field(); ?>

            <div class="col-md-6">
              <label class="form-label">Select Bank Account</label>
              <select name="bank_account_id" class="form-select" required>
                <option value="" selected disabled>Choose account...</option>

                <?php $__empty_1 = true; $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                  <option value="<?php echo e($b->id); ?>">
                    <?php echo e($b->bank_name); ?> — <?php echo e($b->branch_name ?? '-'); ?> • A/c ****<?php echo e(substr($b->account_number, -4)); ?>

                  </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                  <option value="" disabled>No active bank accounts found. Add bank first.</option>
                <?php endif; ?>
              </select>
              <div class="invalid-feedback">Please select a bank account.</div>
            </div>

            <div class="col-md-6">
              <label class="form-label">Amount</label>
              <input type="number"
                     name="amount"
                     id="withdrawAmount"
                     class="form-control"
                     min="1"
                     step="0.01"
                     max="<?php echo e(number_format($balance, 2, '.', '')); ?>"
                     required
                     <?php if(!$canWithdraw): ?> disabled <?php endif; ?>>
              <div class="form-text">You can withdraw up to <strong>₹<?php echo e(number_format($balance,2)); ?></strong>.</div>
              <div class="invalid-feedback">Enter a valid amount (min ₹1, max your balance).</div>
            </div>

            <div class="col-12">
              <?php if($canWithdraw): ?>
                <button id="withdrawBtn" type="submit" class="btn btn-primary">Request Withdrawal</button>
              <?php else: ?>
                <button id="withdrawBtn" type="button" class="btn btn-secondary" disabled>Request Withdrawal</button>
              <?php endif; ?>

              <a href="<?php echo e(route('merchant.index')); ?>" class="btn btn-secondary">Cancel</a>
            </div>
          </form>

        </div>
      </div>

    </div>
  </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
  // form validation bootstrap style
  const forms = document.querySelectorAll('.needs-validation');
  Array.prototype.slice.call(forms).forEach(function (form) {
    form.addEventListener('submit', function (event) {
      // if the submit button is disabled (client safety), block
      var withdrawBtn = document.getElementById('withdrawBtn');
      if (withdrawBtn && withdrawBtn.disabled) {
        event.preventDefault();
        event.stopPropagation();
        return;
      }

      if (!form.checkValidity()) {
        event.preventDefault();
        event.stopPropagation();
      } else {
        // Extra client-side check: amount must be <= balance
        var amtInput = document.getElementById('withdrawAmount');
        if (amtInput && parseFloat(amtInput.value) > parseFloat(amtInput.max || 0)) {
          event.preventDefault();
          event.stopPropagation();
          amtInput.classList.add('is-invalid');
          alert('Amount cannot be greater than your current balance.');
        }
      }
      form.classList.add('was-validated');
    }, false);
  });
});
</script>
<?php /**PATH /var/www/html/pc/hide/resources/views/merchant_panel/withdrawal_form.blade.php ENDPATH**/ ?>