<div class="main-content">
  <div class="page-content">
    <div class="container-fluid">

      <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
      <?php endif; ?>
      <?php if(session('error')): ?>
        <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
      <?php endif; ?>

      <div class="d-flex align-items-center justify-content-between mb-3">
        <h4 class="mb-0">Withdrawal History</h4>
        <a href="<?php echo e(route('merchant.withdraw.form')); ?>" class="btn btn-primary">New Withdrawal</a>
      </div>

      <?php if($withdrawals->count() === 0): ?>
        <div class="alert alert-info">No withdrawal requests found.</div>
      <?php else: ?>
        <div class="card">
          <div class="card-body">
            <div class="table-responsive">
              <table class="table table-striped table-sm">
                <thead>
                  <tr>
                    <th>#</th>
                    <th>Amount</th>
                    <th>Bank</th>
                    <th>Account (last4)</th>
                    <th>Status</th>
                    <th>Requested At</th>
                    <th>Admin Note</th>
                  </tr>
                </thead>
                <tbody>
                  <?php $__currentLoopData = $withdrawals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $w): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                          <td><?php echo e($loop->iteration); ?></td>
                      <td><?php echo e(number_format($w->amount,2)); ?></td>
                      <td><?php echo e($w->bank_name ?? '-'); ?></td>
                      <td>****<?php echo e($w->name_in_bank ? substr($w->name_in_bank, -4) : ( $w->bank_name ? 'xxxx' : '')); ?></td>
                      <td>
                        <?php if($w->status === 'pending'): ?>
                          <span class="badge bg-warning">Pending</span>
                        <?php elseif($w->status === 'approved'): ?>
                          <span class="badge bg-success">Approved</span>
                        <?php else: ?>
                          <span class="badge bg-danger">Rejected</span>
                        <?php endif; ?>
                      </td>
                      <td><?php echo e($w->created_at); ?></td>
                      <td><?php echo e($w->admin_note); ?></td>
                    </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      <?php endif; ?>

    </div>
  </div>
</div>


<?php /**PATH /var/www/html/pc/hide/resources/views/merchant_panel/withdrawal_history.blade.php ENDPATH**/ ?>